using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class AturDeskripsiMakanan : MonoBehaviour
{
    private bool[] isMarker;
    private GameObject makanan;
    private int hitungMarker;
    [SerializeField] int jmlMarker;
    [SerializeField] private Text txNama, txDeskr;

    private void Start()
    {
        isMarker = new bool [jmlMarker];
    }
    
    public void SetMarkerOn(int indexMarker)
    {
        if (!isMarker[indexMarker])
        {
            isMarker[indexMarker] = true;
            hitungMarker++;
        }
    }

    public void SetMarkerOff(int indexMarker)
    {
        if (isMarker[indexMarker])
        {
            isMarker[indexMarker] = false;
            hitungMarker--;
        }
    }

    public void SetMakanan(GameObject makanan)
    {
        this.makanan = makanan;
    }

    private void SetUI(bool b)
    {
        txNama.transform.parent.gameObject.SetActive(b);
        txDeskr.transform.parent.gameObject.SetActive(b);
    }

    // Update is called once per frame
    void Update()
    {
        if (hitungMarker == 0)
        {
            SetUI(false);

            return;
        }

        if(makanan != null)
        {
            SetUI(true);

            for (int i=0; i < isMarker.Length; i++)
            {
                txNama.text = makanan.GetComponent<Makanan>().GetNama();
                txDeskr.text = makanan.GetComponent<Makanan>().GetDeskripsi();
            }
        }
    }
}